// Header File
// Created 24/10/2003; 16:43:21
//Fonctions de base pour arkanoid

//Dclaration de sauvegardes d'interruptions
INT_HANDLER OldInt1 = NULL;
INT_HANDLER OldInt2 = NULL;

void *SaveScreen=NULL;

//Inhibation du clavier
DEFINE_INT_HANDLER (myint2) {pokeIO (0x60001B,0);}

void InstallGame (void)
{				
	//Initialise nombres alatoire
	GCL_Randomize();
	
	//Ne pas dmarrer interruption 1
	StartInt1=MAP_StartInt1=Rackets_anim=StartIntMissiles=StartIntDoubleRacket=StartIntGhost=StartIntMonster=FALSE;
	
	//entry FILE
	entry_fileGFX=GetSymByName (FindFile ("ark_gfx"));
	entry_fileSND=GetSymByName (FindFile ("ark_snd"));
	
	//ark_gfx existe?
	if (entry_fileGFX==NULL) {
		ST_helpMsg ("ark_gfx no found.");
		exit (0);}
	
	//ark_snd existe?
	if (entry_fileSND==NULL) {
		ST_helpMsg ("ark_snd no found.");
		exit (0);}
		
	//ark_lvls existe?
	if (GetSymByName (FindFile ("ark_lvls"))==NULL) {
		ST_helpMsg ("ark_lvls no found.");
		exit (0);}	
	
	//Handles fichiers:
	entry_fileGFX->handle=HeapLock (entry_fileGFX->handle);
	entry_fileSND->handle=HeapLock (entry_fileSND->handle);
		
	//Gestion erreur:
	if ((entry_fileGFX->handle==H_NULL) || (entry_fileSND->handle==H_NULL) || (entry_fileLVL->handle==H_NULL)) {
		ST_helpMsg ("Unknown error with Data Files!");
		exit (0);}	
	
	//Cration des pointeurs FILES
	FileGFX=HeapDeref (entry_fileGFX->handle)+2;
	FileSND=HeapDeref (entry_fileSND->handle)+2;
	
	//-- ALLOCATIONS -- 16000 octets
	if (!(ScreenBuffer=malloc (ScreenBuffer_SIZE)))	{							//Alloue de la mmoire pour ScreenBuffer
		ST_helpMsg ("No enought memory.");
		exit (0);}					
  
  //BlackScreenBuffer (ScreenBuffer);														//Efface le buffer de l'cran virtuel en noir
  
  //Allocations BUFFERMAP
  if (!(BufferMap=malloc (BufferMap_SIZE))) {										//Alloue de la mmoire pour BufferMap
  	free (ScreenBuffer);
  	ST_helpMsg ("No enought memory.");
  	exit (0);}
	
	//Allocation de BufferLifes
	if (!(BufferLifes=malloc (BufferLifes_SIZE))) {								//Alloue de la mmoire pour BufferLifes
  	free (ScreenBuffer);
  	free (BufferMap);
  	ST_helpMsg ("No enought memory.");
  	exit (0);}
	
	//SaveScreen 3840 octets
	if (!(SaveScreen=malloc (LCD_SIZE))) {												//Allocation pour la sauvegarde de l'cran
		free (ScreenBuffer);
		free (BufferMap);
	  free (BufferLifes);
		ST_helpMsg ("No enought memory.");
		exit (0);}
					
	//Inhibe interruption 1 & 2
	OldInt1 = GetIntVec (AUTO_INT_1);
	OldInt2 = GetIntVec (AUTO_INT_2);
	SetIntVec (AUTO_INT_1, interrupt1);
  SetIntVec (AUTO_INT_2, myint2);
  
  //Erreur pas assez de mmoire pour les niveaux de gris
  if (!GrayOn ()) {
  	free (ScreenBuffer);
		free (BufferMap);
	  free (BufferLifes);
	  free (SaveScreen);
	  DeleteGame ();
	  ST_helpMsg ("No enought memory.");
	  exit (0);}
  
  LCD_save (SaveScreen);																				//Sauvegarde de l'cran
  
  //Installation de PolySnd v2.0
  USE_GRAY_WITH_POLYSND;
  pSnd_EnableSound ();
  pSnd_InstallSound ();
  
  //Interruption personnalis PolySnd
  pSnd_Interrupt5 (INT_GAME); 
  
  //Pointeurs sprites
	Create_Sprites ();
  
  //Initialisation de variables
  nbrBille=nbrRacket=nbrBonus=nbrMissile=nbrMissile_anim=nbrMonster=nbrAnimBlocks=0;
  
  //Compteur de temps au jeu
  GAMETIME=0;
}

//Dsinstall le jeu
void UninstallGame (void)
{
	//Unlock Handles
	HeapUnlock (entry_fileGFX->handle);
	HeapUnlock (entry_fileSND->handle);
	HeapUnlock (entry_fileLVL->handle);
	
	free (ScreenBuffer);																					//Libre la mmoire occup par ScreenBuffer
	free (BufferMap);																							//Libre la mmoire occup par BufferMap
	free (BufferLifes);																						//Libre la mmoire occup par BufferLifes
	Destroy_BilleAllocation ();																		//Libre la mmoire occup par les billes
	Destroy_RacketAllocation ();																	//Libre la mmoire occup par les rackets
	Destroy_MonsterAllocation ();																	//Libre la mmoire occup par les monstres
	
	//Desinstalle PolySnd v2.0
	pSnd_UninstallSound ();
	pSnd_DisableSound ();
	
	//Enleve les niveaux de gris
	GrayOff ();
  
  //Restaure interruption 1 & 2
  SetIntVec (AUTO_INT_1, OldInt1);
	SetIntVec (AUTO_INT_2, OldInt2);
	
	LCD_restore (SaveScreen);																			//Restaure l'cran
	free (SaveScreen);																						//Libre la mmoire allou
}


//Efface toutes les allocations mmoire et restaure interruptions
void DeleteGame (void)
{
	//Unlock Handles
	HeapUnlock (entry_fileGFX->handle);
	HeapUnlock (entry_fileSND->handle);
	HeapUnlock (entry_fileLVL->handle);
	
	//Restaure interruption 1 & 2
  SetIntVec (AUTO_INT_1, OldInt1);
	SetIntVec (AUTO_INT_2, OldInt2);
}